import sys
sys.path.append('C:/EnergyPlusV9-5-0')
from pyenergyplus.api import EnergyPlusAPI
from HVACInterface import HVACInterface
from PerformanceCurve import Curve_HPDM
import os

# here is the API of EnergyPlus as a slave
EP_api = EnergyPlusAPI()
HVACapi = HVACInterface()
HVACapi.setEPapi(EP_api)
              
#Define your function to execute in runtime
def my_function(state):
   if EP_api.exchange.api_data_fully_ready(state): #Necessary condition
        if (HVACapi.need_to_get_handles == True):
            # get sensor Handles           
            HVACapi.get_actuator_handles(state)
            HVACapi.get_sensor_handles(state)
            HVACapi.need_to_get_handles =False
        else:
            HVACapi.on_begin_timestep_before_predictor(state)

#After define you function, you must initializate the program
state = EP_api.state_manager.new_state() #Necessary condition
EP_api.state_manager.reset_state(state)
EP_api.runtime.callback_begin_zone_timestep_after_init_heat_balance(state, my_function)
Folder_Output_path = os.path.join('../../EP__VRFSC_5Zone')
Weather_file_path = os.path.join('C:/EnergyPlusV9-5-0/WeatherData/USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw')
IDF_file_path = os.path.join('../../EP__VRFSC_5Zone/SmallOffice_V950_M.idf')
EP_api.runtime.run_energyplus(state, ['-rd', Folder_Output_path, '-w', Weather_file_path, IDF_file_path])
